% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decal.R
\name{estimate_dispersion}
\alias{estimate_dispersion}
\title{Estimate dispersion}
\usage{
estimate_dispersion(count, n = 2000, min_mu = 0.05)
}
\arguments{
\item{count}{UMI count matrix with cells as columns and genes (or features)
as rows.}

\item{n}{number of genes sampled to preliminary estimation.}

\item{min_mu}{minimal overall average expression (\code{mu}) required.}
}
\value{
a numeric vector of the estimated dispersion for each row of \code{count}
}
\description{
It estimates and regularizes the genes (or features) dispersion parameter
of \code{decal} negative binomial model using the strategy developed by
Hafemeister & Satija (2019).
}
\details{
First, for a subset of genes it fits a \emph{Poisson} regression offseted by
\code{log(depth)} and estimate a crude \code{theta} using a maximum likelihood
estimator with the observed counts and regression results. Next, it
regularize and expands \code{theta} estimates with a kernel smoothing function
as a function of average count (\code{mu}).
}
